<?php
include('connection.php');

// Fetch students for Form One
$query = "SELECT id, registration_number, full_name FROM students WHERE class = 'Form One'";
$result = mysqli_query($con, $query);

// Handle attendance submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $date = $_POST['date'];
    $attendanceData = $_POST['attendance'];

    foreach ($attendanceData as $registrationNumber => $status) {
        $sql = "INSERT INTO attendance (registration_number, date, status,class) VALUES (?, ?, ?,'Form One')";
        $stmt = $con->prepare($sql);
        $stmt->bind_param("sss", $registrationNumber, $date, $status);
        $stmt->execute();
        $stmt->close();
    }

    // Redirect after submission to prevent resubmission and editing
    header("Location: attendance_formOne.php?submitted=true");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Form One Attendance</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
</head>
<body>
<div class="container mt-5">
    <h2>Attendance for Form One</h2>

    <!-- Alert if attendance has already been submitted -->
    <?php if (isset($_GET['submitted']) && $_GET['submitted'] == 'true'): ?>
        <div class="alert alert-success">Attendance has been submitted and cannot be edited.</div>
    <?php else: ?>
        <form method="POST" action="attendance_formOne.php">
            <!-- Date Input with current date restriction -->
            <div class="form-group mb-3">
                <label for="date">Select Date</label>
                <input type="date" name="date" id="date" class="form-control" required>
            </div>

            <!-- Attendance Table -->
            <table class="table table-bordered">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Registration Number</th>
                    <th>Full Name</th>
                    <th>Present</th>
                    <th>Absent</th>
                    <th>Sick</th>
                </tr>
                </thead>
                <tbody>
                <?php if (mysqli_num_rows($result) > 0): ?>
                    <?php while ($row = mysqli_fetch_assoc($result)): ?>
                        <tr>
                            <td><?php echo $row['id']; ?></td>
                            <td><?php echo $row['registration_number']; ?></td>
                            <td><?php echo $row['full_name']; ?></td>
                            <td>
                                <input type="radio" name="attendance[<?php echo $row['registration_number']; ?>]" value="Present" required>
                            </td>
                            <td>
                                <input type="radio" name="attendance[<?php echo $row['registration_number']; ?>]" value="Absent" required>
                            </td>
                             <td>
                                <input type="radio" name="attendance[<?php echo $row['registration_number']; ?>]" value="Sick" required>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" class="text-center">No students found</td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>

            <button type="submit" class="btn btn-primary">Submit Attendance</button>
        </form>
    <?php endif; ?>
</div>

<script>
    // Restrict the date input to only the current date
    $(document).ready(function() {
        var today = new Date().toISOString().split('T')[0];
        $('#date').val(today);  // Set default value to today
        $('#date').attr('min', today);  // Disable past dates
        $('#date').attr('max', today);  // Disable future dates
    });
</script>

</body>
</html>
